// Listing 3-13
// UWAGA: W języku Java nie da się przekazać argumentu przez referencję.
// Z tego powodu program ten nie jest odpowiednikiem programu z listingu 3.13
// zamieszczonego w książce.
//
// W tym programie pojawiają się funkcje o nazwach getGrossPay i getBonuses,
// których można użyć jako alternatywy.
// W książce funkcje omówione są w rodziale 6.

import java.util.Scanner;

public class Listing3_13
{
   // Stała globalna zawierająca procentową wysokość składki
   public final static double CONTRIBUTION_RATE = 0.05;
   
   public static void main(String[] args)
   {
      // Zmienne lokalne
      double annualGrossPay;
      double totalBonuses;
      
      // Pobranie wynagrodzenia pracownika
      annualGrossPay = getGrossPay();
      
      // Pobranie wartości wypłaconych premii
      totalBonuses = getBonuses();
      
      // Wyświetlenie składki naliczonej
      // od wynagrodzenia
      showGrossPayContrib(annualGrossPay);
      
      // Wyświetlenie składki naliczonej
      // od premii
      showBonusContrib(totalBonuses);
   }
   
   // Funkcja getGrossPay pobiera od użytkownika
   // wartość wynagrodzenia i wraca ją
   public static double getGrossPay()
   {
      Scanner keyboard = new Scanner(System.in);
      double grossPay;
      System.out.print("Wprowadź wartość wynagrodzenia.");
      grossPay = keyboard.nextDouble();
      return grossPay;
   }
   
   // Funkcja getBonuses pobiera od użytkownika
   // wartość wypłaconych premii i zwraca ją
   public static double getBonuses()
   {
      Scanner keyboard = new Scanner(System.in);
      double bonuses;
      System.out.print("Wprowadź wartość wypłaconych premii.");
      bonuses = keyboard.nextDouble();
      return bonuses;
   }
   
   // Moduł showGrossPayContrib
   // przyjmuje jako argument wartość wynagrodzenia
   // i wyświetla wartość składki naliczonej
   // od wynagrodzenia
   public static void showGrossPayContrib(double grossPay)
   {
      double contrib;
      contrib = grossPay * CONTRIBUTION_RATE;
      System.out.println("Wartość składki naliczona od wynagrodzenia");
      System.out.println("wynosi " + contrib + " zł.");
   }
   
   // Moduł showBonusContrib 
   // przyjmuje jako argument wartość wypłaconych premii
   // i wyświetla wartość składki naliczonej
   // od premii
   public static void showBonusContrib(double bonuses)
   {
      double contrib;
      contrib = bonuses * CONTRIBUTION_RATE;
      System.out.println("Wartość składki naliczona od premii");
      System.out.println("wynosi " + contrib + " zł.");
   }
}